package nemosofts.voxradio.activity;

import android.os.Bundle;
import android.view.MenuItem;

import androidx.activity.EdgeToEdge;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.AppCompatActivity;
import androidx.nemosofts.theme.ColorUtils;

import nemosofts.voxradio.R;
import nemosofts.voxradio.utils.IfSupported;
import nemosofts.voxradio.view.EqualizerFragment;

public class EqualizerActivity extends AppCompatActivity {

    @OptIn(markerClass = UnstableApi.class)
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        IfSupported.isRTL(this);
        IfSupported.isScreenshot(this);
        EdgeToEdge.enable(this);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.bg_page), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });


        int sessionId = PlayerService.getInstance().getAudioSessionID();
        EqualizerFragment equalizerFragment = EqualizerFragment.newBuilder()
                .setAccentColor(ColorUtils.colorPrimary(this))
                .setAudioSessionId(sessionId)
                .build();
        getSupportFragmentManager()
                .beginTransaction()
                .replace(R.id.eqFrame, equalizerFragment)
                .commit();
    }

    @Override
    public int setContentViewID() {
        return R.layout.activity_equilizer;
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            finish();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }
}